/*
 * SensorReading.ino
 *
 *  Created on: May 10, 2015
 *      Author: jcmx9
 */

//constant for pin number
const int triggerPin = 5;                 //to trigger sensor to range
const int echoPin = 6;                    //receive pulse to measure distance

void setup() {
  //set serial commnication baud rate as 9600:
  Serial.begin(9600);
}

void loop() {
  //duration: the width of the "Echo" pulse
  //cm_result: the calculated result of distance in centimeter
  long duration, cm_result;
  
  //based on the data sheet of the HC-SR04, the trigger should be at least 10 us
  //a short LOW pulse (2us) was set beforehand to ensure a clean HIGH pulse
  pinMode(triggerPin, OUTPUT);
  digitalWrite(triggerPin, LOW);
  delayMicroseconds(2);
  digitalWrite(triggerPin, HIGH);
  delayMicroseconds(10);
  digitalWrite(triggerPin, LOW);
  
  //echoPin is used to read pulse from "Echo" pin on the sensor
  //the duration of the pulse is the time (in microseconds) from
  //sending measuring signal to the reception of its echo
  pinMode(echoPin, INPUT);
  //pulseIn functino is defined in wiring_pulse.c file. It will
  //return a long data to state the width of a pulse on specific pin
  duration = pulseIn(echoPin, HIGH);
  
  //convert the time into a distance in centimeter unit
  cm_result = microsecondsToCentimeters(duration);
  
  //serial output the result to PC
  Serial.print("The distance is: ");
  Serial.print(cm_result);
  Serial.print("cm");
  Serial.println();
  
  delay(100);
}

long microsecondsToCentimeters(long microseconds)
{
  //the speed of sound is 340 m/s or 29 microseconds per centimeter.
  //also we should divide the time by two because the ultrasonic wave went twice the distance (back and forth)
  return microseconds / 29 / 2;
}
